package furny.ga.logger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import furny.ga.logger.entities.EventType;
import furny.ga.logger.entities.IndividualEntry;

/**
 * Cache for GA statistics.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public class StatisticsCache {
  // the single instance of StatisticsCache
  private static final StatisticsCache INSTANCE = new StatisticsCache();

  private final Map<List<Object>, List<IndividualEntry>> individualCache = new HashMap<List<Object>, List<IndividualEntry>>();

  private StatisticsCache() {
  }

  public static StatisticsCache getInstance() {
    return INSTANCE;
  }

  public List<IndividualEntry> getIndiduals(final Long runId,
      final EventType... types) {
    final List<Object> key = new ArrayList<Object>();

    key.add(runId);

    for (final EventType type : types) {
      key.add(type);
    }

    Collections.sort(key, new Comparator<Object>() {
      @Override
      public int compare(final Object o1, final Object o2) {
        return o1.hashCode() - o2.hashCode();
      }
    });

    List<IndividualEntry> list = individualCache.get(key);

    if (list == null) {
      list = StatisticsDBManager.getInstance().getIndividuals(runId, types);

      individualCache.put(key, list);
    }

    return list;
  }
}
